using System;
using System.Text;
using System.Xml.Serialization;

namespace com.swvoyages.reservation {

	///
	/// <summary>La classe <code>AirAvailability</code> gre les donnes
	/// d'une disponibilit de la centrale de rservation arienne, 
	/// partenaire de la socit SW-Voyages.</summary> 
	///
	[SoapTypeAttribute("AirAvailability", 
		"http://www.sw-aviation-xml.org:8080/reservation_sw-aviation-xml/schemas/ReservationService-schema")]
	public class AirAvailability {
		
		private static Random idGenerator = new Random();

		private int Id = 0;

		private String AirCompany = "";
		private String FlightNumber = "";
		private String DepartureAirport = "";
		private String ArrivalAirport = "";
		private String DepartureHour = "";
		private String ArrivalHour = "";
		private bool Direction = true;
		private float Price = 0;

		private int RemoteId = 0;

		///
		/// <summary>Le constructeur de disponibilit de la centrale
		/// de rservation arienne.</summary>
		///
		public AirAvailability() {
			this.Id = id;
		}

		///
		/// <summary>Renvoie l'identifiant de la disponibilit
		/// locale.</summary>
		///
		public int id {
			get {
				lock(this) {
					if (Id == 0) {
						Id = idGenerator.Next();
					}
					return Id;
				}
			}
			set {
			}
		}

		///
		/// <summary>Accesseurs du nom de la compagnie arienne.</summary>
		///
		public String airCompany {
			get {
				return AirCompany;
			}
			set {
				this.AirCompany = value;
			}
		}

		///
		/// <summary>Accesseurs du n de vol.</summary>
		///
		public String flightNumber {
			get {
				return FlightNumber;
			}
			set {
				this.FlightNumber = value;
			}
		}

		///
		/// <summary>Accesseurs du nom de l'aroport de dpart.</summary>
		///
		public String departureAirport {
			get {
				return DepartureAirport;
			}
			set {
				this.DepartureAirport = value;
			}
		}

		///
		/// <summary>Accesseurs du nom de l'aroport d'arrive.</summary>
		///
		public String arrivalAirport {
			get {
				return ArrivalAirport;
			}
			set {
				this.ArrivalAirport = value;
			}
		}

		///
		/// <summary>Accesseurs de l'heure de dpart.</summary>
		///
		public String departureHour {
			get {
				return DepartureHour;
			}
			set {
				this.DepartureHour = value;
			}
		}

		///
		/// <summary>Accesseurs de l'heure d'arrive.</summary>
		///
		public String arrivalHour {
			get {
				return ArrivalHour;
			}
			set {
				this.ArrivalHour = value;
			}
		}

		///
		/// <summary>Accesseurs du sens du voyage.</summary>
		///
		public bool direction {
			get {
				return Direction;
			}
			set {
				this.Direction = value;
			}
		}

		///
		/// <summary>Accesseurs du prix de rservation.</summary>
		///
		public float price {
			get {
				return Price;
			}
			set {
				this.Price = value;
			}
		}

		///
		/// <summary>Accesseurs de l'identifiant de la disponibilit
		/// du partenaire.</summary>
		///
		public int remoteId {
			get {
				return RemoteId;
			}
			set {
				this.RemoteId = value;
			}
		}

		///
		/// <summary>Renvoie une reprsentation textuelle de la
		/// disponibilit du partenaire.</summary> 
		///
		/// <returns>une reprsentation textuelle de la disponibilit.
		/// </returns>
		///
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.Append("\r");
			sb.Append(GetType().FullName);
			sb.Append("@");
			sb.Append(System.Convert.ToString(GetHashCode(), 16));
			return sb.ToString();
		}
	}
}